//
// (c) 2020 wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.1
import QtGraphicalEffects 1.0

import wesual.data.Core 1.0
import wesual.Controls 1.0

Rectangle {
    id : languageMenu

    property list<Language> languageListing
    property string currentLanguage

    readonly property bool open : popup.popupVisible

    readonly property int currentIndex : {
        var i = 0;
        for (; i < languageListing.length; ++i) {
            if (languageListing[i].code === currentLanguage)
                break;
        }
        return i;
    }

    function openPopup()  {
        popup.activeIndex = -1;
        popup.show();
        popup.popupItem.focus = true;
    }

    visible : languageListing.length > 1

    onOpenChanged : {
        if (!open && !popup.closedOnTab)
            languageMenu.forceActiveFocus();
        else
            popup.closedOnTab = false;
    }

    activeFocusOnTab : true

    // Key handling
    Keys.onSpacePressed : {
        if (!open) {
            languageMenu.openPopup();
        }
    }
    Keys.onDownPressed : {
        if (!open) {
            openPopup();
        }
    }

    implicitHeight : 26
    implicitWidth  : visible ? 45 : 0

    z : popup.popupVisible ? 10000 : 0

    color : {
        if (ma.pressed || popup.popupVisible)
            return UI.color(UI.PrimaryPress);
        else if (ma.containsMouse || activeFocus)
            return UI.color(UI.PrimaryHover);
        else
            return UI.color(UI.PrimaryBase);
    }

    Rectangle {
        id : indicator

        anchors.right : parent.right
        height : parent.height
        width  : 15
        color : parent.color

        ColorizedImage {
            id : image
            anchors.verticalCenter : parent.verticalCenter
            source : "qrc:/controls/icons/dropdown-indicator.png"
            width  : 10
            height :  5
            anchors {
                right : parent.right
                rightMargin : 3
                verticalCenter : parent.verticalCenter
            }
            color : ma.pressed || popup.popupVisible ?
                    UI.color(UI.PrimaryBase) : UI.color(UI.DropdownIndicatorIcon)
        }
    }

    MouseArea {
        id : ma
        anchors.fill : parent
        hoverEnabled : true
        onClicked : openPopup()
        cursorShape : Qt.PointingHandCursor
    }

    LanguageMenuPopup {
        id : popup

        listing     : languageListing

        onAccepted : {
            currentLanguage = languageListing[result].code;
            popup.hide();
        }
    }
}
